﻿//////////////////////////////////////////////
// GltfEncoder.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkGraphics
#include "../../Dll/DllDefines.h"

#include "../Data/DecodedData.h"

#include "GltfDecodeOptions.h"

// nkMemory
#include <NilkinsMemory/Containers/BufferView.h>

/// Class ------------------------------------

namespace nkGraphics
{
	class DLL_GRAPHICS_EXPORT GltfEncoder final
	{
		public :

			// Decoding
			static bool canDecode (nkMemory::BufferView<> sources) ;
			static DecodedData decode (nkMemory::BufferView<> sources, const GltfDecodeOptions& options = GltfDecodeOptions()) ;
	} ;
}